package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEquality;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.SequenceComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * @author Patrick Harms
 */
public class SequenceComparisonRuleTest {

    /**
     * 
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        SequenceComparisonRule rule = new SequenceComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        ITaskTreeNode task2 = new TaskTreeNode("task2");
        
        assertNull(rule.compare(task1, task2));
        
        ISequence sequence1 = treeNodeFactory.createNewSequence();
        assertEquals(NodeEquality.IDENTICAL, rule.compare(sequence1, sequence1));

        ISequence sequence2 = treeNodeFactory.createNewSequence();
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task1);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task2);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        ISequence sequence3 = treeNodeFactory.createNewSequence();
        treeBuilder.addChild(sequence3, task2);
        treeBuilder.addChild(sequence3, task1);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence1, sequence3));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence3, sequence1));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence2, sequence3));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence3, sequence2));

        ISelection selection = treeNodeFactory.createNewSelection();
        assertNull(rule.compare(sequence1, selection));
        assertNull(rule.compare(selection, sequence1));
        assertNull(rule.compare(sequence2, selection));
        assertNull(rule.compare(selection, sequence2));
        assertNull(rule.compare(sequence3, selection));
        assertNull(rule.compare(selection, sequence3));
    }

}
