
package de.ugoe.cs.autoquest.keyboardmaps;

/**
 * <p>
 * This class is used to define key strokes.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class KeyStroke {

    /**
     * <p>
     * Name of the key stroke.
     * </p>
     */
    private String keyStrokeName;

    /**
     * <p>
     * {@link VirtualKey} associated with the key stroke.
     * </p>
     */
    private VirtualKey virtualKey;

    /**
     * <p>
     * Defines whether numlock is pressed during the stroke.
     * </p>
     */
    private boolean numlock;

    /**
     * <p>
     * Defines whether localstate is pressed during the stroke.
     * </p>
     */
    private boolean localstate;

    /**
     * <p>
     * Defines whether shift is pressed during the stroke.
     * </p>
     */
    private boolean shift;

    /**
     * <p>
     * Defines whether altgr is pressed during the stroke.
     * </p>
     */
    private boolean altgr;

    /**
     * <p>
     * Defines whether inhibit is pressed during the stroke.
     * </p>
     */
    private boolean inhibit;

    /**
     * <p>
     * Defines the character in which the key stroke results.
     * </p>
     */
    private char character;

    /**
     * <p>
     * Constructor. Creates a new key stroke
     * </p>
     * 
     * @param keyStrokeName
     *            name of the key stroke
     * @param virtualKey
     *            virtual key associated with the key stroke
     * @param numlock
     *            defines whether numlock is pressed during the key stroke
     * @param localstate
     *            defines whether localstate is pressed during the key stroke
     * @param shift
     *            defines whether shift is pressed during the key stroke
     * @param altgr
     *            defines whether altgr is pressed during the key stroke
     * @param inhibit
     *            defines whether inhibit is pressed during the key stroke
     * @param character
     *            defines that character in which the key stroke results
     */
    public KeyStroke(String keyStrokeName,
                     VirtualKey virtualKey,
                     boolean numlock,
                     boolean localstate,
                     boolean shift,
                     boolean altgr,
                     boolean inhibit,
                     char character)
    {
        this.keyStrokeName = keyStrokeName;
        this.virtualKey = virtualKey;
        this.numlock = numlock;
        this.localstate = localstate;
        this.shift = shift;
        this.altgr = altgr;
        this.inhibit = inhibit;
        this.character = character;
    }

    /**
     * <p>
     * Returns the name of the key stroke.
     * </p>
     * 
     * @return the name
     */
    public String getKeyStrokeName() {
        return keyStrokeName;
    }

    /**
     * <p>
     * Returns the virtual key associated with the key stroke.
     * </p>
     * 
     * @return the virtual key
     */
    public VirtualKey getVirtualKey() {
        return virtualKey;
    }

    /**
     * <p>
     * Returns the character in which the key stroke results.
     * </p>
     * 
     * @return the character
     */
    public char getCharacter() {
        return character;
    }

    /**
     * <p>
     * Returns whether inhibit is pressed.
     * </p>
     * 
     * @return true if pressed; false otherwise
     */
    public boolean getInhibit() {
        return inhibit;
    }

    /**
     * <p>
     * Returns whether altgr is pressed.
     * </p>
     * 
     * @return true if pressed; false otherwise
     */
    public boolean getAltgr() {
        return altgr;
    }

    /**
     * <p>
     * Returns whether shift is pressed.
     * </p>
     * 
     * @return true if pressed; false otherwise
     */
    public boolean getShift() {
        return shift;
    }

    /**
     * <p>
     * Returns whether localstate is pressed.
     * </p>
     * 
     * @return true if pressed; false otherwise
     */
    public boolean getLocalstate() {
        return localstate;
    }

    /**
     * <p>
     * Returns whether numlock is pressed.
     * </p>
     * 
     * @return true if pressed; false otherwise
     */
    public boolean getNumlock() {
        return numlock;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("KeyStroke(");
        toString.append(keyStrokeName);
        toString.append(", ");
        toString.append(virtualKey);

        if (character != Character.UNASSIGNED) {
            toString.append(", \'");
            toString.append(character);
            toString.append("\'");
        }

        if (shift) {
            toString.append(", shift");
        }

        if (altgr) {
            toString.append(", altgr");
        }

        if (numlock) {
            toString.append(", numlock");
        }

        if (localstate) {
            toString.append(", localstate");
        }

        if (inhibit) {
            toString.append(", inhibit");
        }

        toString.append(")");

        return toString.toString();
    }

}
