
package de.ugoe.cs.autoquest.plugin.jfc.commands;

import java.io.File;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.plugin.jfc.JFCTraceCorrector;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that tries to correct all files in a folder as if they were log files generated by the
 * older version of the JFCMonitor which sometimes do not include correct event sources. The result
 * is another specified directory, which contains the corrected files.
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class CMDcorrectDirOldJFC implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String path;
        String resultPath;

        try {
            path = (String) parameters.get(0);
            resultPath = (String) parameters.get(1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }

        File folder = new File(path);
        if (!folder.isDirectory()) {
            Console.printerrln(path + " is not a directory");
            return;
        }

        File destfolder = new File(resultPath);
        if (!destfolder.isDirectory()) {
            Console.printerrln(resultPath + " is not a directory");
            return;
        }

        JFCTraceCorrector corrector = new JFCTraceCorrector();

        String absolutPath = folder.getAbsolutePath();
        String absolutDestPath = destfolder.getAbsolutePath();
        for (String filename : folder.list()) {
            String source = absolutPath + "/" + filename;
            String dest = absolutDestPath + "/" + filename;
            Console.traceln(Level.INFO, "Processing file: " + source);

            corrector.correctFile(source, dest);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "correctDirOldJFC <sourcedirectory> <destinationdirectory>";
    }

}
