// Module    : $RCSfile: JFCRadioButton.java,v $
// Version   : $Revision: 0.0 $  $Author: pharms $  $Date: 03.09.2012 $
// Project   : quest-plugin-jfc
// Creation  : 2012 by pharms
// Copyright : Patrick Harms, 2012

package de.ugoe.cs.autoquest.plugin.jfc.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IRadioButton;

/**
 * <p>
 * Class that represents radio buttons in JFC GUIs.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class JFCRadioButton extends JFCGUIElement implements IRadioButton {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new JFCRadioButton.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public JFCRadioButton(JFCGUIElementSpec specification, JFCGUIElement parent) {
        super(specification, parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.jfc.guimodel.JFCGUIElement#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return "RadioButton";
    }
}
