
package de.ugoe.cs.autoquest.eventcore.guimodel;

/**
 * <p>
 * Exception that is thrown if there is a failure during the creation of a {@link IGUIElement} by
 * the {@link GUIElementFactory}.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class GUIModelConfigurationException extends GUIModelException {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new GUIModelConfigurationException.
     * </p>
     */
    public GUIModelConfigurationException() {
        super();
    }

    /**
     * <p>
     * Constructor. Creates a new GUIModelConfigurationException.
     * </p>
     * 
     * @param message
     *            message of the exception
     */
    public GUIModelConfigurationException(String message) {
        super(message);
    }

    /**
     * <p>
     * Constructor. Creates a new GUIModelConfigurationException.
     * </p>
     * 
     * @param cause
     *            cause of the exception
     */
    public GUIModelConfigurationException(Throwable cause) {
        super(cause);
    }

    /**
     * <p>
     * Constructor. Creates a new GUIModelConfigurationException.
     * </p>
     * 
     * @param message
     *            message of the exception
     * @param cause
     *            cause of the exception
     */
    public GUIModelConfigurationException(String message, Throwable cause) {
        super(message, cause);
    }

}
