//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.htmlmonitor;

/**
 * <p>
 * represents an event caused by a user on a specific web site. An event contains the infos
 * about the client ({@link HtmlClientInfos}, when ant where the event took place, the type of
 * event and some additional infos such as the event coordinates or the number of the pressed
 * key. 
 * </p>
 * 
 * @author Patrick Harms
 */
class HtmlEvent {

    /**
     * infos about the client that caused the event
     */
    private HtmlClientInfos clientInfos;

    /**
     * the time stamp of the event
     */
    private Long time;

    /**
     * the path in the HTML DOM to the object on which the event was executed
     */
    private String path;

    /**
     * the type of the event, e.g. onclick
     */
    private String eventType;

    /**
     * the coordinates of the event, usually an array with two values (x and y)
     */
    private Integer[] coordinates;

    /**
     * if the event is a key event, the key that was pressed or released
     */
    private Integer key;

    /**
     * if the event is a scroll event, the resulting position of the scrolled element
     */
    private Integer scrollPosition;

    /**
     * <p>
     * initializes the event with all relevantinfos
     * </p>
     *
     * @param clientInfos    infos about the client that caused the event
     * @param time           the time stamp of the event
     * @param path           the path in the HTML DOM to the object on which the event was executed
     * @param eventType      the type of the event, e.g. onclick
     * @param coordinates    the coordinates of the event, usually an array with two values
     *                       (x and y)
     * @param key            if the event is a key event, the key that was pressed or released
     * @param scrollPosition if the event is a scroll event, the resulting position of the
     *                       scrolled element
     */
    HtmlEvent(HtmlClientInfos clientInfos,
              Long            time,
              String          path,
              String          eventType,
              Integer[]       coordinates,
              Integer         key,
              Integer         scrollPosition)
    {
        this.clientInfos = clientInfos;
        this.time = time;
        this.path = path;
        this.eventType = eventType;
        this.coordinates = coordinates;
        this.key = key;
        this.scrollPosition = scrollPosition;
    }

    /**
     * @return the clientInfos
     */
    HtmlClientInfos getClientInfos() {
        return clientInfos;
    }

    /**
     * @return the time
     */
    Long getTime() {
        return time;
    }

    /**
     * @return the path
     */
    String getPath() {
        return path;
    }

    /**
     * @return the eventType
     */
    String getEventType() {
        return eventType;
    }

    /**
     * @return the coordinates
     */
    Integer[] getCoordinates() {
        return coordinates;
    }

    /**
     * @return the key
     */
    Integer getKey() {
        return key;
    }

    /**
     * @return the scrollPosition
     */
    Integer getScrollPosition() {
        return scrollPosition;
    }

}
