//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.php;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import de.ugoe.cs.autoquest.plugin.QuestPlugin;

/**
 * <p>
 * Identifier class for the QUEST PHP plug-in.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class PHPPlugin implements QuestPlugin {

	/**
	 * <p>
	 * The command packages of this plug-in.
	 * </p>
	 */
	private final static String[] commandPackages = new String[] { "de.ugoe.cs.autoquest.plugin.php.commands" };

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.plugin.QuestPlugin#getTitle()
	 */
	@Override
	public String getTitle() {
		return "GUITAR-Plugin";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.plugin.QuestPlugin#getCommandPackages()
	 */
	@Override
	public List<String> getCommandPackages() {
	        return Collections.unmodifiableList(Arrays.asList(commandPackages));
	}
}
