/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.SystemProperties;

public class FindBugsMessageFormat {
    private String pattern;

    public FindBugsMessageFormat(String pattern) {
        this.pattern = pattern;
    }

    public String format(BugAnnotation[] args, ClassAnnotation primaryClass) {
        return this.format(args, primaryClass, false);
    }

    public String format(BugAnnotation[] args, ClassAnnotation primaryClass, boolean abridgedMessages) {
        String pat = this.pattern;
        StringBuilder result = new StringBuilder();
        while (pat.length() > 0) {
            int fieldNum;
            int subst = pat.indexOf(123);
            if (subst < 0) {
                result.append(pat);
                break;
            }
            result.append(pat.substring(0, subst));
            pat = pat.substring(subst + 1);
            int end = pat.indexOf(125);
            if (end < 0) {
                throw new IllegalStateException("unmatched { in " + pat);
            }
            String substPat = pat.substring(0, end);
            int dot = substPat.indexOf(46);
            String key = "";
            if (dot >= 0) {
                key = substPat.substring(dot + 1);
                substPat = substPat.substring(0, dot);
            } else if (abridgedMessages && primaryClass != null) {
                key = "givenClass";
            }
            try {
                fieldNum = Integer.parseInt(substPat);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad integer value " + substPat + " in " + this.pattern);
            }
            if (fieldNum < 0) {
                result.append("?<?" + fieldNum + "/" + args.length + "???");
            } else if (fieldNum >= args.length) {
                result.append("?>?" + fieldNum + "/" + args.length + "???");
            } else {
                BugAnnotation field = args[fieldNum];
                String formatted = "";
                try {
                    formatted = field.format(key, primaryClass);
                }
                catch (IllegalArgumentException iae) {
                    if (SystemProperties.ASSERTIONS_ENABLED) {
                        throw new IllegalArgumentException("Problem processing " + this.pattern + " format " + substPat + " for " + field.getClass().getSimpleName(), iae);
                    }
                    formatted = "\u00bf" + fieldNum + ".(key=" + key + ")?";
                }
                result.append(formatted);
            }
            pat = pat.substring(end + 1);
        }
        return result.toString();
    }
}

