//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for a double click, i.e., pressing the mouse, releasing it, pressing it, and releasing
 * it again right away.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class MouseDoubleClick extends MouseButtonInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link MouseDoubleClick} event type.
     * </p>
     * 
     * @see MouseButtonInteraction#MouseButtonInteraction(Button)
     */
    public MouseDoubleClick(Button button) {
        super(button);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        if (super.getButton() == Button.LEFT) {
            return "LeftMouseDoubleClick";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "MiddleMouseDoubleClick";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "RightMouseDoubleClick";
        }
        else {
            return "UnknownMouseButtonDoubleClick";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (super.getButton() == Button.LEFT) {
            return "left mouse double click";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "middle mouse double click";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "right mouse double click";
        }
        else {
            return "unknown mouse button double click";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseDoubleClick) {
            return getButton().equals(((MouseDoubleClick) obj).getButton());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode();
    }
}
