//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import org.junit.Before;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.autoquest.tasktrees.temporalrelation.TemporalRelationshipRuleManager;
import de.ugoe.cs.autoquest.tasktrees.testutils.Utilities;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;
import de.ugoe.cs.util.console.TextConsole;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class AbstractTemporalRelationshipTC {

    /** */
    private List<IEventTask> events;

    /** */
    private ITaskTreeBuilder taskTreeBuilder = new TaskTreeBuilder();

    /** */
    private ITaskTreeNodeFactory taskTreeNodeFactory = new TaskTreeNodeFactory();

    /** */
    private NodeEqualityRuleManager nodeEqualityRuleManager =
        Utilities.getNodeEqualityRuleManagerForTests();

    /**
   *
   */
    @Before
    public void setUp() {
        new TextConsole(Level.FINEST);
        events = new ArrayList<IEventTask>();
    }

    /**
     *
     */
    protected void simulateEvent(IEventType eventType, IEventTarget eventTarget) {
        events.add(taskTreeNodeFactory.createNewEventTask(eventType, eventTarget));
    }

    /**
     *
     * @return
     */
    protected ITaskTree getTaskTree() {
        ISequence sequence = taskTreeNodeFactory.createNewSequence();

        for (IEventTask task : events) {
            taskTreeBuilder.addChild(sequence, task);
        }

        TemporalRelationshipRuleManager ruleManager =
            new TemporalRelationshipRuleManager(nodeEqualityRuleManager);

        ruleManager.init();
        ruleManager.applyRules(sequence, taskTreeBuilder, taskTreeNodeFactory, true);

        return taskTreeNodeFactory.createTaskTree(sequence);
    }

}
