//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest;

import java.util.logging.Level;

import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Helper class that collects methods that are often used by the commands.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CommandHelpers {

	/**
	 * <p>
	 * Prints a message to error stream of the {@link Console} that an object
	 * has not been found in the storage.
	 * </p>
	 * 
	 * @param objectName
	 *            name of the object
	 */
	public static void objectNotFoundMessage(String objectName) {
		Console.printerrln("Object " + objectName + " not found in storage.");
	}

	/**
	 * <p>
	 * Prints a message to the error stream of the {@link Console} that an
	 * object is not of an expected type.
	 * </p>
	 * 
	 * @param objectName
	 *            name of the object
	 * @param type
	 *            expected type
	 */
	public static void objectNotType(String objectName, String type) {
		Console.printerrln("Object " + objectName + "not of type " + type + ".");
	}

	/**
	 * <p>
	 * Prints a message to the trace stream of the {@link Console} that an
	 * object in the storage has been overwritten.
	 * </p>
	 * 
	 * @param objectName
	 */
	public static void dataOverwritten(String objectName) {
		Console.traceln(Level.INFO, "Existing object " + objectName + " overwritten.");
	}
}
