//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.mfc;

import de.ugoe.cs.autoquest.plugin.mfc.guimodel.MFCWindowTree;

/**
 * <p>
 * Handles {@code WM_SETTEXT} messages. Handler maintains the {@link MFCWindowTree}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class HandlerSetText extends MessageHandler {

    /**
     * <p>
     * Constructor. Creates a new HanderSetText.
     * </p>
     * 
     * @param windowTree
     *            the tree of GUI element specifications to be created and adapted during parsing
     */
    public HandlerSetText(MFCWindowTree windowTree) {
        super(windowTree);
    }

    /**
     * <p>
     * New name of the window.
     * </p>
     */
    private String windowName;

    /**
     * <p>
     * HWND of the window.
     * </p>
     */
    private long hwnd;

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.mfc.MessageHandler#onEndElement()
     */
    @Override
    public void onEndElement() {
        if (hwnd != 0) {
            super.getWindowTree().setName(hwnd, windowName);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.mfc.MessageHandler#onParameter(java.lang.String ,
     * java.lang.String)
     */
    @Override
    public void onParameter(String name, String value) {
        if (name.equals("window.hwnd")) {
            hwnd = Long.parseLong(value);
        }
        else if (name.equals("window.newText")) {
            windowName = value;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.mfc.MessageHandler#onStartElement()
     */
    @Override
    public void onStartElement() {
        windowName = "";
        hwnd = 0;
    }
}
