/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;
import org.apache.bcel.generic.ElementValuePairGen;
import org.apache.bcel.generic.ObjectType;

public class AnnotationEntryGen {
    private int typeIndex;
    private List evs;
    private ConstantPoolGen cpool;
    private boolean isRuntimeVisible = false;

    public AnnotationEntryGen(AnnotationEntry a, ConstantPoolGen cpool, boolean copyPoolEntries) {
        this.cpool = cpool;
        this.typeIndex = copyPoolEntries ? cpool.addUtf8(a.getAnnotationType()) : a.getAnnotationTypeIndex();
        this.isRuntimeVisible = a.isRuntimeVisible();
        this.evs = this.copyValues(a.getElementValuePairs(), cpool, copyPoolEntries);
    }

    private List copyValues(ElementValuePair[] in, ConstantPoolGen cpool, boolean copyPoolEntries) {
        ArrayList<ElementValuePairGen> out = new ArrayList<ElementValuePairGen>();
        int l = in.length;
        for (int i = 0; i < l; ++i) {
            ElementValuePair nvp = in[i];
            out.add(new ElementValuePairGen(nvp, cpool, copyPoolEntries));
        }
        return out;
    }

    private AnnotationEntryGen(ConstantPoolGen cpool) {
        this.cpool = cpool;
    }

    public AnnotationEntry getAnnotation() {
        AnnotationEntry a = new AnnotationEntry(this.typeIndex, this.cpool.getConstantPool(), this.isRuntimeVisible);
        Iterator iter = this.evs.iterator();
        while (iter.hasNext()) {
            ElementValuePairGen element = (ElementValuePairGen)iter.next();
            a.addElementNameValuePair(element.getElementNameValuePair());
        }
        return a;
    }

    public AnnotationEntryGen(ObjectType type, List elements, boolean vis, ConstantPoolGen cpool) {
        this.cpool = cpool;
        this.typeIndex = cpool.addUtf8(type.getSignature());
        this.evs = elements;
        this.isRuntimeVisible = vis;
    }

    public static AnnotationEntryGen read(DataInputStream dis, ConstantPoolGen cpool, boolean b) throws IOException {
        AnnotationEntryGen a = new AnnotationEntryGen(cpool);
        a.typeIndex = dis.readUnsignedShort();
        int elemValuePairCount = dis.readUnsignedShort();
        for (int i = 0; i < elemValuePairCount; ++i) {
            int nidx = dis.readUnsignedShort();
            a.addElementNameValuePair(new ElementValuePairGen(nidx, ElementValueGen.readElementValue(dis, cpool), cpool));
        }
        a.isRuntimeVisible(b);
        return a;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeIndex);
        dos.writeShort(this.evs.size());
        for (int i = 0; i < this.evs.size(); ++i) {
            ElementValuePairGen envp = (ElementValuePairGen)this.evs.get(i);
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(ElementValuePairGen evp) {
        if (this.evs == null) {
            this.evs = new ArrayList();
        }
        this.evs.add(evp);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public final String getTypeSignature() {
        ConstantUtf8 utf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return utf8.getBytes();
    }

    public final String getTypeName() {
        return this.getTypeSignature();
    }

    public List getValues() {
        return this.evs;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("AnnotationGen:[" + this.getTypeName() + " #" + this.evs.size() + " {");
        for (int i = 0; i < this.evs.size(); ++i) {
            s.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            s.append(",");
        }
        s.append("}]");
        return s.toString();
    }

    public String toShortString() {
        StringBuffer s = new StringBuffer();
        s.append("@" + this.getTypeName() + "(");
        for (int i = 0; i < this.evs.size(); ++i) {
            s.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            s.append(",");
        }
        s.append(")");
        return s.toString();
    }

    private void isRuntimeVisible(boolean b) {
        this.isRuntimeVisible = b;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }
}

