//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.guitar.eventcore;

import de.ugoe.cs.autoquest.IReplayDecorator;
import de.ugoe.cs.autoquest.eventcore.IReplayable;
import de.ugoe.cs.autoquest.plugin.guitar.EFGReplayDecorator;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * {@link IReplayable} used to generate test cases for the GUITAR suite.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class GUITARReplayable implements IReplayable {

    /**
     * <p>
     * EventId in the EFG and GUI files.
     * </p>
     */
    String eventId;

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link GUITARReplayable}.
     * </p>
     * 
     * @param eventId
     */
    public GUITARReplayable(String eventId) {
        this.eventId = eventId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IReplayable#getReplay()
     */
    @Override
    public String getReplay() {
        StringBuilder replay = new StringBuilder();
        replay.append("<Step>" + StringTools.ENDLINE);
        replay.append("<EventId>" + eventId + "</EventId>" + StringTools.ENDLINE);
        replay.append("<ReachingStep>false</ReachingStep>" + StringTools.ENDLINE);
        replay.append("</Step>" + StringTools.ENDLINE);
        return replay.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IReplayable#getDecorator()
     */
    @Override
    public IReplayDecorator getDecorator() {
        return EFGReplayDecorator.getInstance();
    }

}
