//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.gui.ValueSelection;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.ITrackBar;
import de.ugoe.cs.autoquest.tasktrees.TaskTreeChecker;
import de.ugoe.cs.autoquest.test.DummyGUIElement;
import de.ugoe.cs.autoquest.test.DummyInteraction;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class TrackBarSelectionDetectionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void testSimpleDetection() throws Exception {
        IGUIElement element1 = new DummyTrackBar();
        simulateEvent(new ValueSelection<Integer>(1), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(2), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(3), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(2), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(3), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

    }

    /**
     *
     */
    @Test
    public void testComplexDetection() throws Exception {
        IGUIElement element1 = new DummyTrackBar();
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new ValueSelection<Integer>(2), element1);
        simulateEvent(new ValueSelection<Integer>(3), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new DummyInteraction("bla", 1), element1);
        simulateEvent(new DummyInteraction("bla", 2), element1);
        simulateEvent(new ValueSelection<Integer>(2), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new DummyInteraction("bla", 3), element1);
        simulateEvent(new ValueSelection<Integer>(3), element1);
        simulateEvent(new ValueSelection<Integer>(2), element1);
        simulateEvent(new ValueSelection<Integer>(3), element1);
        simulateEvent(new DummyInteraction("bla", 1), element1);
        simulateEvent(new DummyInteraction("bla", 2), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "  Event bla {}" +
             "  Event bla {}" +
             "  Iteration interation2 {" +
             "    Selection selection2 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "  Event bla {}" +
             "  Iteration interation3 {" +
             "    Selection selection3 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "  Event bla {}" +
             "  Event bla {}" +
             "  Iteration interation4 {" +
             "    Selection selection4 {" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());
    }

    /**
     * TODO comment
     * 
     * @version $Revision: $ $Date: 28.04.2012$
     * @author 2012, last modified by $Author: patrick$
     */
    public class DummyTrackBar extends DummyGUIElement implements ITrackBar {

        /**  */
        private static final long serialVersionUID = 1L;

         /**
          *
          */
         public DummyTrackBar() {
            super("DummyTrackBar");
        }
    }

}
