//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import java.net.URL;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLGUIElementSpec implements IGUIElementSpec {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private URL pageURL;
    
    /** */
    private String pageTitle;
    
    /** */
    private String type;
    
    /** */
    private String id;
    
    /** */
    private int index;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param type
     * @param index
     * @param id
     */
    public HTMLGUIElementSpec(URL pageURL, String pageTitle, String type, String id, int index) {
        if (pageURL == null) {
            throw new IllegalArgumentException("page URL must not be null");
        }
        else if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        else if ((id == null) && (index < 0)) {
            throw new IllegalArgumentException
              ("either id must not be null or the index must be greater or equal to 0");
        }
        
        this.pageURL = pageURL;
        this.pageTitle = pageTitle;
        this.type = type;
        this.id = id;
        this.index = index;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getType()
     */
    @Override
    public String getType() {
        return type;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getSimilarity(IGUIElementSpec)
     */
    @Override
    public boolean getSimilarity(IGUIElementSpec other) {
        if (other instanceof HTMLGUIElementSpec) {
            HTMLGUIElementSpec otherSpec = (HTMLGUIElementSpec) other;
            
            if (!type.equals(otherSpec.type)) {
                return false;
            }
            
            if (id != null) {
                return id.equals(otherSpec.id);
            }
            else if (index >= 0) {
                return index == otherSpec.index;
            }
        }
        
        return false;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    URL getPageURL() {
        return pageURL;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getPageTitle() {
        return pageTitle;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getTagId() {
        return id;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    int getIndex() {
        return index;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param htmlguiElementSpec
     */
    void update(HTMLGUIElementSpec htmlguiElementSpec) {
        // TODO Auto-generated method stub
        System.out.println("TODO: implement HTMLGUIElementSpec.update ");
        
    }

}
