package de.ugoe.cs.eventbench.commands;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDsave implements Command {

	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		}
		catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		
		FileOutputStream fos = null;
		ObjectOutputStream out = null;
		try {
			fos = new FileOutputStream(filename);
			out = new ObjectOutputStream(fos);
			out.writeObject(GlobalDataContainer.getInstance());
			out.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public void help() {
		Console.println("Usage: saveObject <filename>");
	}

}
