//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.jfc.commands;

import java.util.List;

import de.ugoe.cs.autoquest.plugin.jfc.JFCTraceCorrector;
import de.ugoe.cs.util.console.Command;

/**
 * <p>
 * Command to correct an XML file with sessions monitored by the older version of the
 * EventBench's JFCMonitor which sometimes do not include correct event sources.
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class CMDcorrectOldJFC implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String inputfilename;
        String outputfilename;

        try {
            inputfilename = (String) parameters.get(0);
            outputfilename = (String) parameters.get(1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }

        JFCTraceCorrector corrector = new JFCTraceCorrector();

        corrector.correctFile(inputfilename, outputfilename);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "correctOldJFC <inputfilename> <outputfilename>";
    }

}
