/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.DocumentException;

public class CountByPackagePrefix {
    private static final String USAGE = "Usage: <cmd>  <prefixLength> [<bugs.xml>]";

    public static void main(String[] args) throws IOException, DocumentException {
        Integer v;
        String prefix;
        DetectorFactoryCollection.instance();
        if (args.length != 1 && args.length != 2) {
            System.out.println(USAGE);
            return;
        }
        int prefixLength = Integer.parseInt(args[0]);
        SortedBugCollection origCollection = new SortedBugCollection();
        if (args.length == 1) {
            origCollection.readXML(System.in);
        } else {
            origCollection.readXML(args[1]);
        }
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        TreeMap<String, Integer> ncss = new TreeMap<String, Integer>();
        for (BugInstance bugInstance : origCollection.getCollection()) {
            prefix = ClassName.extractPackagePrefix(bugInstance.getPrimaryClass().getPackageName(), prefixLength);
            v = (Integer)map.get(prefix);
            if (v == null) {
                map.put(prefix, 1);
                continue;
            }
            map.put(prefix, v + 1);
        }
        for (PackageStats packageStats : origCollection.getProjectStats().getPackageStats()) {
            prefix = ClassName.extractPackagePrefix(packageStats.getPackageName(), prefixLength);
            v = (Integer)ncss.get(prefix);
            if (v == null) {
                ncss.put(prefix, packageStats.size());
                continue;
            }
            ncss.put(prefix, v + packageStats.size());
        }
        for (Map.Entry entry : map.entrySet()) {
            prefix = (String)entry.getKey();
            int warnings = (Integer)entry.getValue();
            if (warnings == 0) continue;
            Integer v2 = (Integer)ncss.get(prefix);
            if (v2 == null || v2 == 0) {
                v2 = 1;
            }
            int density = warnings * 1000000 / v2;
            if (warnings < 3 || v2 < 2000) {
                System.out.printf("%4s %4d %4d %s%n", " ", warnings, v2 / 1000, prefix);
                continue;
            }
            System.out.printf("%4d %4d %4d %s%n", density, warnings, v2 / 1000, prefix);
        }
    }
}

