//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.mfc;

import de.ugoe.cs.autoquest.IReplayDecorator;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * {@link IReplayDecorator} for replay generated for EventBench's MFCReplay tool.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class MFCReplayDecorator implements IReplayDecorator {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * The instance of the {@link MFCReplayDecorator} (implemented as
	 * singleton).
	 * </p>
	 */
	transient private static MFCReplayDecorator theInstance;

	/**
	 * <p>
	 * Constructor. Private to guarantee that only one instance of the replay
	 * generator exists.
	 * </p>
	 */
	private MFCReplayDecorator() {
	};

	/**
	 * <p>
	 * Returns the instance of the MFCReplayDecorator.
	 * </p>
	 * 
	 * @return instance of the MFCReplayDecorator.
	 */
	public static MFCReplayDecorator getInstance() {
		if (theInstance == null) {
			theInstance = new MFCReplayDecorator();
		}
		return theInstance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.IReplayDecorator#getHeader()
	 */
	@Override
	public String getHeader() {
		return "<?xml version=\"1.0\" encoding=\"UTF-16\"?>"
				+ StringTools.ENDLINE + "<log>" + StringTools.ENDLINE;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.IReplayDecorator#getFooter()
	 */
	@Override
	public String getFooter() {
		return "</log>" + StringTools.ENDLINE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.IReplayDecorator#getSessionHeader(int)
	 */
	@Override
	public String getSessionHeader(int sessionId) {
		return " <session id=\"" + sessionId + "\">" + StringTools.ENDLINE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.IReplayDecorator#getSessionFooter(int)
	 */
	@Override
	public String getSessionFooter(int sessionId) {
		return " </session>" + StringTools.ENDLINE;
	}

}
